require( "scripts/style.lua" )

HeaderFont = {
  standardFont,
  30,
  RedColor
};

TableInfoFont = {
  standardFont,
  30,
 BorderColor
};

ErrorFont = {
  standardFont,
  24,
 BorderColor
};

AccountFont = {
  standardFont,
  22,
  BorderColor
};

ScoreFont = {
  standardFont,
  14,
  BorderColor
};

HiscoreSubmitLegal = {
  standardFont,
  14,
  BorderColor
};

kPlayerNameY = 80;
kScoreY = 130;
kYourPFAccountY = 180;
kAccountNameY = 205;
kPasswordY = 240;
kRememberY = 280;


kPrivacyLabel = 'privacy';
if (IsAnonHighScoreMode()) then
	kPrivacyLabel = 'privacy_info';
end

MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/longdialog",	
		x=kCenter,
		y=kCenter,

		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=0,y=kScoreY,w=142,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=205,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "12345"
		};
		
		Text
		{
			font = ScoreFont,
			name = "yourpfaccount",
			x=145,y=kYourPFAccountY,w=150,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=20,y=0,w=kMax-20,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};


		Bitmap
		{
			name="nameeditbox",
			image="backgrounds/shorttextfield.png",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "nameedit",
				x=0,y=3,w=kMax,h=kMax,
				length=kMaxUserNameLength,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="backgrounds/shorttextfield.png",
			x=155,
			y=kAccountNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "accountedit",
				x=0,y=3,w=kMax,h=kMax,
				length=kMaxPFUsernameLength,
				ignore = kIllegalLoginChars
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="backgrounds/shorttextfield.png",
			x=155,
			y=kPasswordY,
			
			TextEdit
			{
				font = AccountFont,
				name = "passedit",
				x=0,y=3,w=kMax,h=kMax,
				password = true,
				length=kMaxPFPasswordLength
				
			};
		};
		
		
		Button
		{
			font = StandardButtonFont,
			graphics = CheckboxButtonGraphics,
			name="remember",
			type = kToggle,
			x=75,
			y=kRememberY,
			w=250,
			scale=0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = StandardButtonFont,
				name = "rememberlabel",
				x=25,
				y=10,
				w=250,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		SetStyle(StandardButtonStyle);
		Button
		{
			x=50,
			y=360,
			name="submittoserver",
			label="submit",
			default = true,
			type = kPush
		},
		
		Button
		{
			x=225,
			y=360,
			name="submitcancel",
			label="cancel",
			type = kPush
		};
		SetStyle(DefaultStyle);
		
		SetStyle(StandardButtonStyle);
		Button
		{
			x=kCenter,
			y=360,
			name="submiterrorok",
			label="ok"
		};
		SetStyle(DefaultStyle);
		
		LinkText
		{
			x = kLongDialogX, w = kLongDialogW,
			y = 400, h = kMax,
			font = HiscoreSubmitLegal;
			flags = kHAlignLeft + kVAlignTop,
			label = kPrivacyLabel
		};
		
		Button
		{
			x=0,
			y=0,
			w=0,
			h=0,
			name="privacybutton",
			command = 
				function()
					if (IsAnonHighScoreMode()) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="privacy_anon",
							title = ""
						};
					elseif (MultiplayerEnabled()) then
						LaunchHarnessPost('manager', 'content', '../privacypolicy.html');
					else
						LaunchPrivacyPolicy();
					end
				end
		};
	}
}

